program UpperTriBackSub;
{--------------------------------------------------------------------}
{  Alg3'2.pas   Pascal program for implementing Algorithm 3.2        }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 3.2 (Upper-Triangularization Followed by Back Subs.).   }
{  Section   3.4, Gaussian Elimination and Pivoting, Page 156        }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    MaxR = 10;
    MaxC = 11;

  type
    SubR = 1..MaxR;
    SubC = 1..MaxC;
    VECTOR = array[SubR] of real;
    MATRIX = array[SubR, SubC] of real;
    POINTER = array[SubR] of integer;
    LETTER = string[4];
    STATUS = (Done, Nonsingular, Singular, Working);
    LETTERS = string[200];

  var
    Digits, Hor, Mdigits, InRC, Inum, N, Sub, Ver: integer;
    Log10, Rnum: real;
    X: VECTOR;
    A, A1: MATRIX;
    Ans: CHAR;
    Ach, Bch: LETTER;
    Mess: LETTERS;
    Cond, Stat: STATUS;

  procedure GaussElim (A: MATRIX; var X: VECTOR; N: integer; var Cond: STATUS);
    label
      999;
    var
      C, J, K, P, T: integer;
      M, SUM: real;
      Row: POINTER;
  begin
    Cond := Nonsingular;
    for J := 1 to N do                      {Initialize pointer vector}
      Row[J] := J;
    for P := 1 to N - 1 do                 {Upper triangularization loop}
      begin
        for K := P + 1 to N do
          begin                                          {Find Pivot row}
            if ABS(A[Row[K], P]) > ABS(A[Row[P], P]) then
              begin
                T := Row[P];
                Row[P] := Row[K];
                Row[K] := T;
              end;
            if A[Row[P], P] = 0 then                 {Check singular matrix}
              begin
                WRITELN('A(', Row[P], ',', P, ') = ', A[Row[P], P]);
                Cond := Singular;
                goto 999;
              end;
          end;
        for K := P + 1 to N do                       {Gaussian elimination}
          begin
            M := A[Row[K], P] / A[Row[P], P];
            for C := P + 1 to N + 1 do
              A[Row[K], C] := A[Row[K], C] - M * A[Row[P], C];
          end;                                 {End Gaussian elimination}
      end;                                  {End upper triangularization}
    if A[Row[N], N] = 0 then                     {Check singular matrix}
      begin
        Cond := Singular;
        goto 999;
      end;
    X[N] := A[Row[N], N + 1] / A[Row[N], N];                {Back substitution}
    for K := N - 1 downto 1 do
      begin
        SUM := 0;
        for C := K + 1 to N do
          SUM := SUM + A[Row[K], C] * X[C];
        X[K] := (A[Row[K], N + 1] - SUM) / A[Row[K], K];
      end;
999:
  end;                                     {End of procedure GaussElim}

  procedure INPUTMATRIX (var Ach: LETTER; var A, A1: MATRIX; N, InRC: integer);
    var
      Count, C, K, R: integer;
      Z: VECTOR;
  begin
    for R := 1 to N do
      begin
        for C := 1 to N do
          begin
            A[R, C] := 0;
            A1[R, C] := A[R, C];
          end;
      end;
    WRITELN('     Input the elements of the ', N : 1, ' by ', N : 1, ' coefficient matrix  ', Ach);
    if (InRC = 1) then
      begin
        for R := 1 to N do
          begin
            WRITELN('ENTER all the coefficients of row ', R, ' on one row');
            WRITELN;
            for K := 1 to N do
              Z[K] := 0;
            case N of
              1: 
                READLN(Z[1]);
              2: 
                READLN(Z[1], Z[2]);
              3: 
                READLN(Z[1], Z[2], Z[3]);
              4: 
                READLN(Z[1], Z[2], Z[3], Z[4]);
              5: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5]);
              6: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6]);
              7: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7]);
              8: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8]);
              9: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9]);
              10: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9], Z[10]);
            end;
            for C := 1 to N do
              begin
                A[R, C] := Z[C];
                A1[R, C] := A[R, C];
              end;
          end;
      end
    else if (InRC = 2) then
      begin
        for R := 1 to N do
          begin
            WRITELN('     ENTER the coefficients of row ', R);
            WRITELN;
            for C := 1 to N do
              begin
                WRITE('     A(', R : 2, ',', C : 2, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
              end;
          end;
      end
    else
      begin
        for C := 1 to N do
          begin
            WRITELN('     ENTER the coefficients of column ', C);
            WRITELN;
            for R := 1 to N do
              begin
                WRITE('     A(', R : 2, ',', C : 2, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
              end;
          end;
      end;
  end;                                   {End of procedure INPUTMATRIX}

  procedure Aoutput (Ach: LETTER; A: MATRIX; N: integer);
    var
      Digits, Mdigits, C, R: integer;
      Log10: real;
  begin
    Log10 := LN(10);
    WRITELN;
    WRITELN('The matrix  ', Ach, '  is:');
    for R := 1 to N do
      begin
        WRITELN;
        for C := 1 to N - 1 do
          begin
            Digits := 7;
            if A[R, C] <> 0 then
              Mdigits := 1 + TRUNC(LN(ABS(A[R, C])) / Log10);
            if A[R, C] < 0 then
              Mdigits := Mdigits + 1;
            if Mdigits < 7 then
              Mdigits := 7;
            Digits := 14 - Mdigits;
            WRITE(A[R, C] : 15 : Digits, ' ');
          end;
        Digits := 7;
        if A[R, N] <> 0 then
          Mdigits := 1 + TRUNC(LN(ABS(A[R, N])) / Log10);
        if A[R, N] < 0 then
          Mdigits := Mdigits + 1;
        if Mdigits < 7 then
          Mdigits := 7;
        Digits := 14 - Mdigits;
        WRITE(A[R, N] : 15 : Digits);
        if N > 5 then
          WRITELN;
      end;
    WRITELN;
  end;                                       {End of procedure Aoutput}

  procedure INPUTVECTOR (var Bch: LETTER; var A: MATRIX; N: integer);
    var
      R: integer;
  begin
    for R := 1 to N do
      A[R, N + 1] := 0;
      CLRSCR;
    Aoutput(Ach, A1, N);
    WRITELN('Enter the Column Vector  ', Bch);
    WRITELN;
    for R := 1 to N do                               {Input Vector B}
      begin
        WRITE('     B(', R : 2, ') = ');
        READLN(A[R, N + 1]);
      end;
  end;                                   {End of procedure INPUTVECTOR}

  procedure REFRESH (var A: MATRIX; A1: MATRIX; N: integer);
    var
      C, R: integer;
  begin
    for R := 1 to N do
      begin
        for C := 1 to N + 1 do
          begin
            A[R, C] := A1[R, C];
          end;
      end;
  end;

  procedure Boutput (Bch: LETTER; A: MATRIX; N: integer);
    var
      J: integer;
  begin
    WRITELN;
    WRITELN('     The Vector  ', Bch, '  is:');
    WRITELN;
    for J := 1 to N do
      begin
        WRITELN('     B(', J : 2, ') =', A[J, N + 1] : 15 : 7);
      end;
    WRITELN;
  end;                                      {End of procedure BXoutput}

  procedure CHANGEMATRIX (Ach: LETTER; var A, A1: MATRIX; N: integer);
    type
      STATUS = (Bad, Enter, Done);
      LETTER = string[1];
    var
      Count, C, I, K, R: integer;
      Ans: CHAR;
      Stat: STATUS;
  begin
    Stat := Enter;
    while (Stat = Enter) or (Stat = Bad) do
      begin
        CLRSCR;
        Aoutput(Ach, A1, N);
        WRITELN;
        WRITELN;
        if (Stat <> Bad) then
          begin
            WRITE('Do you want to make a change in the matrix ? <Y/N> ');
            READLN(Ans);
          end;
        if (Ans = 'Y') or (Ans = 'y') or (Stat = Bad) then
          begin
            WRITELN('     To change a coefficient select');
            case N of
              2: 
                begin
                  WRITELN('        the row    R = 1,2');
                  WRITELN('        and column C = 1,2');
                end;
              3: 
                begin
                  WRITELN('        the row    R = 1,2,3');
                  WRITELN('        and column C = 1,2,3');
                end;
              else
                begin
                  WRITELN('        the row    R = 1,2,...,', N : 2);
                  WRITELN('        and column C = 1,2,...,', N : 2);
                end;
            end;
            Mess := '     ENTER the row R = ';
            R := 0;
            WRITE(Mess);
            READLN(R);
            Mess := '     ENTER column  C = ';
            C := 0;
            WRITE(Mess);
            READLN(C);
            if (1 <= R) and (R <= N) and (1 <= C) and (C <= N) then
              begin
                WRITELN('     The current value is A(', R : 2, ',', C : 2, ') =', A[R, C] : 15 : 7);
                WRITELN;
                WRITE('     ENTER the NEW value  A(', R : 2, ',', C : 2, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
                WRITELN;
              end;
          end
        else
          Stat := Done;
      end;
  end;

  procedure CHANGEVECTOR (Bch: LETTER; var A: MATRIX; N: integer);
    type
      STATUS = (Enter, Done);
      LETTER = string[1];
    var
      Count, C, I, K, R: integer;
      Valu: real;
      Ans: CHAR;
      Stat: STATUS;
  begin
    Stat := Enter;
    while (Stat = Enter) do
      begin
        CLRSCR;
        WRITELN;
        Boutput(Bch, A, N);
        WRITE('     Do you want to make a change in the vector ? <Y/N> ');
        READLN(Ans);
        if (Ans = 'Y') or (Ans = 'y') then
          begin
            WRITE('     To change a coefficient select the row ');
            case N of
              2: 
                WRITELN('R = 1,2');
              3: 
                WRITELN('R = 1,2,3');
              else
                WRITELN('R = 1,2,...,', N : 2);
            end;
            WRITELN;
            Mess := '                              ENTER the row R = ';
            R := 0;
            WRITE(Mess);
            READLN(R);
            if (1 <= R) and (R <= N) then
              begin
                WRITELN('     The current value is B(', R : 2, ') =', A[R, N + 1] : 15 : 7);
                WRITE('     ENTER the NEW value  B(', R : 2, ') = ');
                READLN(A[R, N + 1]);
                WRITELN;
              end;
          end
        else
          Stat := Done;
      end;
  end;

  procedure MESSAGE (var InRC: integer);
    var
      I: integer;
      Ans: CHAR;
  begin
    CLRSCR;
    for I := 1 to 3 do
      WRITELN;
    WRITELN('                        GAUSSIAN ELIMINATION');
    WRITELN;
    WRITELN;
    WRITELN('               Solution of the linear system   A*X = B,');
    WRITELN;
    WRITELN('          where  A  is a non-singular matrix.');
    WRITELN;
    WRITELN('          Gaussian elimination is used to construct');
    WRITELN;
    WRITELN('          an equivalent upper-triangular linear system');
    WRITELN;
    WRITELN('                        U*X = Y.');
    WRITELN;
    WRITELN('          Then back-substitution is used to find X.');
    WRITELN;
    WRITELN;
    WRITELN;
    WRITE('                        Press the <ENTER> key.  ');
    READLN(Ans);
    CLRSCR;
    WRITELN;
    WRITELN('        Choose how you want to input the elements of the matrix.');
    WRITELN;
    WRITELN('    <1> Enter the elements of each row on one line separated by spaces, i.e.');
    WRITELN;
    WRITELN('        A(J,1)  A(J,2)  ...  A(J,N)           for J=1,2,...,N');
    WRITELN;
    WRITELN('    <2> Enter each element of a row on a separate line, i.e.');
    WRITELN;
    WRITELN('        A(J,1)');
    WRITELN('        A(J,2)');
    WRITELN('           .');
    WRITELN('           :');
    WRITELN('        A(J,N)     for J=1,2,...,N');
    WRITELN;
    WRITELN('    <3> Enter each element of a column on a separate line, i.e.');
    WRITELN;
    WRITELN('        A(1,K)');
    WRITELN('        A(2,K)');
    WRITELN('           .');
    WRITELN('           :');
    WRITELN('        A(N,K)     for K=1,2,...,N');
    WRITELN;
    Mess := '        SELECT <1 - 3> ?  ';
    InRC := 3;
    WRITE(Mess);
    READLN(InRC);
    if (InRC <> 1) and (InRC <> 2) and (InRC <> 3) then
      InRC := 2;
  end;                                  {End of procedure MESSAGE}

  procedure INPUTS (var A, A1: MATRIX; var N, InRC: integer);
    var
      C, R: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('     Solution of the linear system of equations  A*X = B.');
    WRITELN;
    WRITELN('          A  is a matrix of dimension  N by N.');
    WRITELN;
    WRITELN('          B  is an  N  dimensional vector.');
    WRITELN;
    WRITELN('         {N  must be an integer between 1 and 10}');
    WRITELN;
    Mess := '   ENTER  N  = ';
    N := 2;
    WRITE(Mess);
    READLN(N);
    if (N < 2) then
      N := 2;
    if (N > 10) then
      N := 10;
    CLRSCR;
    Ach := 'A';
    INPUTMATRIX(Ach, A, A1, N, InRC);
    CHANGEMATRIX(Ach, A, A1, N);
    Bch := 'B';
    INPUTVECTOR(Bch, A, N);
    CHANGEVECTOR(Bch, A, N);
  end;                                   {End of procedure INPUTS}

  procedure RESULTS (A: MATRIX; X: VECTOR; N: integer; Cond: STATUS);
    var
      C, R: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('The matrix  A  is:');
    for R := 1 to N do
      begin
        WRITELN;
        for C := 1 to N do
          WRITE(A[R, C] : 15 : 7, ' ');
      end;
    WRITELN;
    WRITELN;
    case Cond of
      Singular: 
        begin
          WRITELN('The matrix is singular.');
          WRITELN;
          WRITELN('A zero pivot element was encountered.');
          WRITELN;
          WRITELN('Gaussian elimination will not produce a solution.');
        end;
      NonSingular: 
        begin
          WRITELN('Column vector  B(J):           Solution vector  X(J):');
          Log10 := LN(10);
          for R := 1 to N do
            begin
              WRITELN;
              Digits := 7;
              if A[R, N + 1] <> 0 then
                Mdigits := 1 + TRUNC(LN(ABS(A[R, N + 1])) / Log10);
              if A[R, N + 1] < 0 then
                Mdigits := Mdigits + 1;
              if Digits < 7 then
                Mdigits := 7;
              Digits := 14 - Mdigits;
              WRITE('B(', R : 2, ') = ', A[R, N + 1] : 15 : Digits, '         ');
              WRITE('X(', R : 2, ') = ', X[R] : 15 : 7);
            end;
        end;
    end;
    WRITELN;
  end;                                       {End of procedure RESULTS}

begin                                              {The Main Program}
  MESSAGE(InRC);
  Stat := Working;
  while (Stat = Working) do
    begin
      N := MaxR;
      INPUTS(A, A1, N, InRC);
      GaussElim(A, X, N, Cond);
      RESULTS(A, X, N, Cond);
      WRITELN;
      WRITE('Want  to  solve  another  problem ? <Y/N>  ');
      READLN(Ans);
      if (Ans <> 'Y') and (Ans <> 'y') then
        Stat := Done
    end;
end.                                            {End of Main Program}

